/*
** Source Lines of Code Counter         (c) Copyright IBM Corp., 1987, 1992
**                                      For Internal Use Only
**    by: Jeffrey W. Hamilton  (JEFFH at WMAVM7)
*/
#include "global.h"

sym_list *build_list(char *filename)
{
   register int found;
   char *i,save;
#if defined(OS_DOS) || defined(OS_OS2)
   char path[DISKNAME_LIMIT + PATHNAME_LIMIT + 1];
#endif
   char name[FULLNAME_LIMIT + 1];
   sym_list *list, *temp_list;
#if defined(OS_DOS)
   struct ffblk ffblk;
#elif defined(OS_OS2)
   HDIR dirhandle = 0x1;
#if defined(OS_OS2_1)
   FILEFINDBUF resultbuf;
   USHORT searchcount;
#else
   FILEFINDBUF3 resultbuf;
   ULONG searchcount;
#endif
#endif

   list = NULL;

   /*
   ** Build list of file names with path attached
   */
#if defined(OS_DOS)
   found = findfirst(filename, &ffblk, 0);
#elif defined(OS_OS2)
   searchcount = 1;
#if defined(OS_OS2_1)
   found = DosFindFirst(filename, &dirhandle, (USHORT) 0, &resultbuf, sizeof(resultbuf), &searchcount, (ULONG) 0);
#else
   found = DosFindFirst(filename, &dirhandle, (USHORT) 0, &resultbuf, sizeof(resultbuf), &searchcount, (ULONG) FIL_STANDARD);
#endif
#elif defined(OS_MVS) || defined(OS_VM) || defined(OS_AIX)
   found = findfirst(filename, name);
#endif
   if (found != 0) {
      if (errno == ENOENT) {
         fprintf(stderr,"No files found matching the name %s\n",filename);
      }
      return(NULL);
   }

#if defined(OS_DOS) || defined(OS_OS2)
   /*
   ** Separate Path from File name
   */
   if ((i = strrchr(filename,'\\')) == NULL) {
      if ((i = strrchr(filename,':')) == NULL) {
         path[0] = '\0'; /* no path */
      } else {
         save = *(i+1);
         *(i+1) = '\0';
         strcpy(path,filename);
         *(i+1) = save;
      }
   } else {
      save = *(i+1);
      *(i+1) = '\0';
      strcpy(path,filename);
      *(i+1) = save;
   }
#endif
   while (found == 0) {
#if defined(OS_DOS)
      strcpy(name,path);
      strcat(name,ffblk.ff_name);
      if (strchr(ffblk.ff_name,'.') == NULL) {
         /* no extension, force a period at the end */
         strcat(name,".");
      }
#elif defined(OS_OS2)
      strcpy(name,path);
      strcat(name,resultbuf.achName);
      if (strchr(resultbuf.achName,'.') == NULL) {
         /* no extension, force a period at the end */
         strcat(name,".");
      }
#elif defined(OS_VM)
      name[strlen(name)-1] = '\0'; /* remove filemode number from the name */
#endif
      temp_list = (sym_list *) malloc(sizeof(sym_list));
      check_space(temp_list);
      temp_list->next = list;
      list = temp_list;
      list->name = (char *) malloc(strlen(name) + 1);
      check_space(list->name);
      strcpy(list->name,name);
      list->lines = list->comments = list->code = 0;
#if defined(OS_DOS)
      found = findnext(&ffblk);
#elif defined(OS_OS2)
      searchcount=1;
      found = DosFindNext(dirhandle,&resultbuf,sizeof(resultbuf),&searchcount);
#elif defined(OS_VM) || defined(OS_MVS) || defined(OS_AIX)
      found = findnext(name);
#endif
   }

   /*
   ** Add list to main list of files
   */
   if (list != NULL){
      /* Find last item */
      if (counts == NULL) {
         counts = list;
      } else {
         for (temp_list = counts; temp_list->next != NULL ; temp_list = temp_list->next);
         temp_list->next = list;
      }
   }

   return(list);
}

#if defined(OS_DOS) || defined(OS_OS2)
/*
**  Routine to open file
**  Directories are checked as follows:
**    Current Directory
**    Directories on DPATH
**    Directories on PATH
*/

FILE *xfopen(char *fname,       /* Input file name */
             char *fmode)       /* File open mode (same as used for fopen) */
{
   char filename[256];
   char *path;
   char pathname[256];

   path = getenv("DPATH");
   pathname[0] = '\0';
   while (1) {
      strcpy(filename,pathname);
      strcat(filename,fname);
      if (access(filename,0) == 0) {
         return fopen(filename,fmode);
      }
      if ((path != NULL) && (path[0] != '\0')) {
         sscanf(path,"%[^;]",pathname);
         if ('\0' == pathname[0]) break;
         path = strpbrk(path,";")+1;
         if (pathname[strlen(pathname)-1] != '\\') {
            strcat(pathname,"\\");
         }
      } else {
         break;
      }
   }
   path = getenv("PATH");
   pathname[0] = '\0';
   while (1) {
      strcpy(filename,pathname);
      strcat(filename,fname);
      if (access(filename,0) == 0) {
         return fopen(filename,fmode);
      }
      if ((path != NULL) && (path[0] != '\0')) {
         sscanf(path,"%[^;]",pathname);
         if ('\0' == pathname[0]) break;
         path = strpbrk(path,";")+1;
         if (pathname[strlen(pathname)-1] != '\\') {
            strcat(pathname,"\\");
         }
      } else {
         break;
      }
   }

   strcpy(filename,fname);
   return NULL;
}
#elif defined(OS_AIX)
/*
**  Routine to open file
**  Directories are checked as follows:
**    Current Directory
**    Directories on PATH
*/

FILE *xfopen(char *fname,       /* Input file name */
             char *fmode)       /* File open mode (same as used for fopen) */
{
   char filename[FULLNAME_LIMIT];
   char *path;
   char pathname[PATHNAME_LIMIT];
   FILE *F;

   if (strstr(fname,"/") != NULL) {
      F=fopen(fname,fmode);
      return F;
   }
   path = getenv("PATH");
   pathname[0] = '\0';
   while (path[0] != '\0') {
      strcpy(filename,pathname);
      strcat(filename,fname);
      if (access(filename,0) == 0) {
         F=fopen(filename,fmode);
         return F;
      }
      if (path[0] != '\0') {
         sscanf(path,"%[^:]",pathname);
         path = strpbrk(path,":")+1;
         if ('\0' == pathname[0]) {
            pathname[0]='.';
            pathname[1]='/';
            pathname[2]='\0';
         }
         if (pathname[strlen(pathname)-1] != '/') {
            strcat(pathname,"/");
         }
      } else {
         break;
      }
   }

   return NULL;
}
#elif defined(OS_VM) || defined(OS_MVS)
/*
**  Routine to open file
*/
FILE *xfopen(char *fname,       /* Input file name */
             char *fmode)       /* File open mode (same as used for fopen) */
{
   return fopen(fname, fmode);
}
#endif

#if defined(OS_OS2)
/*
** Split filename into its components
*/
void fnsplit(char *name, char *drive, char *dir, char *filename, char *extension)
{
   char *tempchar, *s, *t;
   register int i;

   /* Remove drive if present */
   if ((tempchar = strchr(name,':')) != NULL) {
      for (s = name, t = drive, i = 0; (i < 1) && (s < tempchar); s++, t++, i++) {
         *t = *s;
      }
      *t = ':';
      *(t+1) = '\0';
      name = tempchar+1;
   } else {
      drive[0] = '\0';
   }

   /* Remove path if present */
   if ((tempchar = strrchr(name,'\\')) != NULL) {
      for (s = name, t = dir, i = 0; (i < 64) && (s < tempchar); s++, t++, i++) {
         *t = *s;
      }
      *t = '\\';
      *(t+1) = '\0';
      name = tempchar+1;
   } else {
      dir[0] = '\0';
   }

   /* Remove file name and extension */
   if ((tempchar = strrchr(name,'.')) != NULL) {
      for (s = name, t = filename, i = 0; (i < 8) && (s < tempchar); s++, t++, i++) {
         *t = *s;
      }
      *t = '\0';
      strncpy(extension,tempchar,4);
      extension[4] = '\0';
   } else {
      strncpy(filename,name,8);
      filename[8] = '\0';
      extension[0] = '.';
      extension[1] = '\0';
   }
}
#elif defined(OS_AIX)
/*
** Split filename into its components
**
** Note: the drive string is left in for ease of porting
*/
void fnsplit(char *name, char *drive, char *dir, char *filename, char *extension)
{
   char *tempchar, *s, *t;
   register int i;

   /* There is no drive in AIX */
   drive[0] = '\0';

   /* Remove path if present */
   if ((tempchar = strrchr(name,'/')) != NULL) {
      for (s = name, t = dir, i = 0; (i < PATHNAME_LIMIT) && (s < tempchar);
           s++, t++, i++) {
         *t = *s;
      }
      *t = '/';
      *(t+1) = '\0';
      name = tempchar+1;
   } else {
      dir[0] = '\0';
   }

   /* Remove file name and extension */
   if ((tempchar = strrchr(name,'.')) != NULL) {
      for (s = name, t = filename, i = 0; (i < FILENAME_LIMIT) &&
           (s < tempchar); s++, t++, i++) {
         *t = *s;
      }
      *t = '\0';
      strncpy(extension,tempchar,EXTENSION_LIMIT-1);
      extension[EXTENSION_LIMIT-1] = '\0';
   } else {
      strncpy(filename,name,FILENAME_LIMIT-1);
      filename[FILENAME_LIMIT-1] = '\0';
      extension[0] = '\0';
   }
}
#elif defined(OS_MVS)
/*
** Split filename into its components
** - Added handling of overriding extensions - Peter Wu 1991
*/
void fnsplit(char *name, char *mode, char *dir, char *filename, char *extension)
{
   char *tempchar, *s, *t,temp[10];
   int dot_count, inside_paren, found_filename, fn_start_dot, ext_start_dot;
   register int i;


   /* The file name may be in one of two places in the input name   */
   /* If the input name contains a member, then the member name     */
   /* becomes the file name.                                        */

   strcpy(temp,"");
   dot_count = 0;
   found_filename = 0;
   inside_paren = 0;
   t = filename;

   for (s = name; (*s != '\0'); s++) {

      if (*s != '\'') {              /* skip over any quotation marks */

        if (*s == '.')  dot_count++;

        if (*s == ')') {
          inside_paren = 0;
          if( *(s+1)==':' )
          {
            strcpy(temp,s+2);
            *(s+1)='\0';
          }
          if( strncmp(s+1,"':",2)==0 ) { /* Found Overriding Ext! */
            strcpy(temp,s+3);
            *(s+1)='\0';
          }
        }

        if (inside_paren) {
          *t = toupper(*s);
          t++;
          found_filename = 1;
        }

        if (*s == '(') inside_paren = 1;
      }
   }

   /* If the input name does not contain a member, then the second  */
   /* to last segment of the input name becomes the filename.       */

   fn_start_dot = dot_count - 1;
   ext_start_dot = dot_count;

   if (!found_filename) {
     dot_count = 0;
     for (s = name; (*s != '\0'); s++) {
     if( *s == ':' ) {     /* Found overriding Extension! */
       strcpy(temp,s+1);
       *s='\0';
     }
       if (*s != '\'') {             /* skip over any quotation marks */

         if (*s == '.') dot_count++;

         else
           if (dot_count == fn_start_dot) {
             *t = toupper(*s);
             t++;
           }
       }
     }
   }

   *t = '\0';

   /* In either case, the last level of the input name becomes the  */
   /* extension.                                                    */

   dot_count = 0;
   t = extension;

   for (s = name; (*s != '\0'); s++) {
     if (*s != '\'') {             /* skip over any quotation marks */

       if (*s == '(') dot_count++;/* increment dot_count to stop at */
                                  /* parenthesis or close quote     */

       if (*s == '.') dot_count++;

       else
         if (dot_count == ext_start_dot) {
           *t = toupper(*s);
           t++;
         }
     }
   }
   *t = '\0';
   if( temp[0]!='\0' )   /* Override Extension */
     strcpy(extension,temp);
}
#elif defined(OS_VM)
/*
** Split filename into its components
** - Added handling of overriding extensions - Peter Wu 1991
*/
void fnsplit(char *name, char *mode, char *dir, char *filename, char *extension)
{
   char *tempchar, *s, *t, *tmpstr;
   register int i;

   /* Remove file name */
   for (s = name, t = filename; (*s != '\0') && (*s != '.'); s++, t++) {
      *t = toupper(*s);
   }
   *t = '\0';

   /* Remove any overriding extensions */
   if( tmpstr=strchr(name,':') ) {
     strcpy(extension,tmpstr+1);
     *tmpstr='\0';
   }
   else
   { /* Remove extension */
     if (*s == '.') s++;
     extension[0] = '.';
     for (t = &extension[1]; (*s != '\0') && (*s != '.'); s++, t++) {
        *t = toupper(*s);
     }
     *t = '\0';
   }

   /* Remove mode */
   if (*s == '.') s++;
   for (t = mode; (*s != '\0') && (*s != '.'); s++, t++) {
      *t = toupper(*s);
   }
   *t = '\0';
}
#endif

#if defined(OS_VM)
/*
** The following will locate all files matching a specification
** and return the files one at a time.
** Both functions return 0 if a file was found and -1 if there are
** no more matching files.
*/
static FILE *stack;
static int   numfiles = -1;
static int   buflev;

int findfirst(char *filespec, char *filename)
{
   char fn[9], ft[9], fm[3], dir[1], *curpt, *aux, line[80];
   int listrc, i;

   fnsplit(filespec,fm,dir,fn,ft);

   curpt=line;
   aux="LISTFILE";                while(*curpt++=*aux++); *(curpt-1)=' ';
   aux=fn;                        while(*curpt++=*aux++); *(curpt-1)=' ';
   aux=&ft[1];                    while(*curpt++=*aux++); *(curpt-1)=' ';
   aux=fm;                        while(*curpt++=*aux++); *(curpt-1)=' ';
   aux="( FIFO NOHEADER FMODE";   while(*curpt++=*aux++);
   buflev = system("MAKEBUF");
   listrc = system(line);
   if (0 != listrc) {           /* no files satisfy input spec */
     *filename=0;               /* empty string */
     return(-1);
   }

   numfiles = system("SENTRIES");          /* number of files */
   printf("%d files found\n",numfiles);
   stack = fopen("*","r");
   fgets(line, sizeof line, stack);
   sscanf(line,"%s %s %s",fn,ft,fm);
   curpt = filename;
   aux=fn; while(*curpt++=*aux++); *(curpt-1)='.';
   aux=ft; while(*curpt++=*aux++); *(curpt-1)='.';
   aux=fm; while(*curpt++=*aux++);
   *curpt=0;
   numfiles -= 1;
   return(0);
}

int findnext(char *filename)
{
   char fn[9], ft[9], fm[3], *curpt, *aux, line[80];
   int listrc, i;

   if (numfiles == 0) {
      fclose(stack);
      sprintf(line,"DROPBUF %d",buflev);
      system(line);
      numfiles = -1;
      return(-1);
   } else if (numfiles < 0) {
      return(-1);
   }

   fgets(line, sizeof line, stack);
   sscanf(line,"%s %s %s",fn,ft,fm);
   curpt = filename;
   aux=fn; while(*curpt++=*aux++); *(curpt-1)='.';
   aux=ft; while(*curpt++=*aux++); *(curpt-1)='.';
   aux=fm; while(*curpt++=*aux++);
   *curpt=0;
   numfiles -= 1;
   return(0);
}

#elif defined(OS_AIX)
/*
** The following will locate all files matching a specification
** and return the files one at a time.
** Both functions return 0 if a file was found and -1 if there are
** no more matching files.
*/
static FILE *stack;
static FILE *pathstack;
static char searchspec[FULLNAME_LIMIT];

static int findfirstpath(char *path)
{
  system("ls -R * | grep : > /tmp/sloccpath.tmp");

  if ((pathstack = fopen("/tmp/sloccpath.tmp","r")) == NULL) {
    /* Error - can't open file with the listing */
    return -1;
  }

  /* The first path is always the current directory */
  strcpy(path,".");
  return 0;
}

static int findnextpath(char *path)
{
  if (pathstack == NULL) return -1;

  /* Get another file name if it exists */
  if (fscanf(pathstack, " %[^:]:",path) == 1) {
    return 0;
  } else {
    fclose(pathstack);
    errno = EACCES;
    return -1;
  }
}


int findfirst(char *filespec, char *filename)
{
   char line[512];
   char path[PATHNAME_LIMIT];

   if (recurse != 0) {
     findfirstpath(path);
     strcpy(searchspec, filespec);
   }
   sprintf(line, "echo %s > /tmp/slocc.tmp", filespec);
   if (debug) printf("%s\n",line);
   system(line);

   if ((stack = fopen("/tmp/slocc.tmp","r")) == NULL) {
      /* Error - can't open file with the listing */
      return -1;
   }
   if (fscanf(stack, " %[^ \t\n]",filename) == 1) {
      return 0;
   } else {
      /* Error - No matching file found */
      fclose(stack);
      if (recurse != 0) {
	/* Try another directory */
	while (findnextpath(path) == 0) {
	  sprintf(line, "ls %s/%s > /tmp/slocc.tmp", path, searchspec);
	  if (debug) printf("%s\n",line);
	  system(line);

	  if ((stack = fopen("/tmp/slocc.tmp","r")) == NULL) {
	    /* Error - can't open file with the listing */
	    return -1;
	  }
	  if (fscanf(stack, " %[^ \t\n]",filename) == 1) {
	    return 0;
	  }
	}
      }
      errno = ENOENT;
      return -1;
   }
}

int findnext(char *filename)
{
  char line[512];
  char path[PATHNAME_LIMIT];

  if (fscanf(stack, " %[^ \t\n]",filename) == 1) {
    return 0;
  } else {
    /* Error - Out of files */
    fclose(stack);
    if (recurse != 0) {
      /* Try another directory */
      while (findnextpath(path) == 0) {
	sprintf(line, "ls %s/%s > /tmp/slocc.tmp", path, searchspec);
	if (debug) printf("%s\n",line);
	system(line);

	if ((stack = fopen("/tmp/slocc.tmp","r")) == NULL) {
	  /* Error - can't open file with the listing */
	  return -1;
	}
	if (fscanf(stack, " %[^ \t\n]",filename) == 1) {
	  return 0;
	}
      }
    }
    /* No more paths */
    errno = EACCES;
    return -1;
  }
}
#elif defined(OS_MVS)
/*
** I don't know how to do wildcard matching under MVS, so we
** just check that the given file exists.
*/
int findfirst(char *filespec, char *filename)
{
   FILE *fp;

   if ((fp = fopen(filespec,"r")) != NULL) {
      fclose(fp);
      strcpy(filename,filespec);
      return 0;
   } else {
      return -1;
   }
}
int findnext(char *filespec)
{
   /* No wildcards, so only one file matches */
   return -1;
}
#endif
